package furny.ga.rules;

import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import ga.core.GA;
import ga.core.validation.GAContext;
import ga.core.validation.IValidationRule;
import ga.view.interfaces.IPhenotypeSpace;

/**
 * This is a {@link IValidationRule} implementation that keeps all furnitures in
 * the room.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class RoomContainsRule implements IValidationRule<FurnLayoutIndividual> {

  @Override
  public float matchingDegree(final FurnLayoutIndividual individual,
      final GAContext context) {

    final Object o = context.get(GA.KEY_VALIDATION_SPACE);

    if (o != null && o instanceof IPhenotypeSpace) {
      final IPhenotypeSpace space = (IPhenotypeSpace) o;

      for (final FurnEntry entry : individual.getFurnitures()) {
        if (!space.contains(entry.getBounds())) {
          return 0;
        }
      }

    } else {
      throw new RuntimeException("Phenotype space not found in the ga context");
    }

    return 1;
  }

  @Override
  public IValidationRule.Type getType() {
    return Type.MANDATORY;
  }
}
